import React, { useState } from 'react';
import { LineChart, Line, BarChart, Bar, PieChart, Pie, Cell, XAxis, YAxis, CartesianGrid, Tooltip, Legend, ResponsiveContainer } from 'recharts';
import './App.css';

const data = [
  { name: 'Jan', users: 4000, revenue: 2400, sessions: 2400 },
  { name: 'Feb', users: 3000, revenue: 1398, sessions: 2210 },
  { name: 'Mar', users: 2000, revenue: 9800, sessions: 2290 },
  { name: 'Apr', users: 2780, revenue: 3908, sessions: 2000 },
  { name: 'May', users: 1890, revenue: 4800, sessions: 2181 },
  { name: 'Jun', users: 2390, revenue: 3800, sessions: 2500 },
];

const pieData = [
  { name: 'Desktop', value: 400, color: '#3b82f6' },
  { name: 'Mobile', value: 300, color: '#10b981' },
  { name: 'Tablet', value: 100, color: '#f59e0b' },
];

function App() {
  const [dateRange, setDateRange] = useState('7d');
  
  return (
    <div className="app">
      <header className="header">
        <h1>Analytics Dashboard</h1>
        <div className="date-selector">
          <select value={dateRange} onChange={(e) => setDateRange(e.target.value)}>
            <option value="24h">Last 24 hours</option>
            <option value="7d">Last 7 days</option>
            <option value="30d">Last 30 days</option>
            <option value="90d">Last 90 days</option>
          </select>
        </div>
      </header>

      <div className="metrics-grid">
        <div className="metric-card">
          <h3>Total Users</h3>
          <p className="metric-value">24,567</p>
          <span className="metric-change positive">+12.5%</span>
        </div>
        <div className="metric-card">
          <h3>Revenue</h3>
          <p className="metric-value">$45,231</p>
          <span className="metric-change positive">+8.2%</span>
        </div>
        <div className="metric-card">
          <h3>Sessions</h3>
          <p className="metric-value">142,543</p>
          <span className="metric-change negative">-2.4%</span>
        </div>
        <div className="metric-card">
          <h3>Conversion Rate</h3>
          <p className="metric-value">3.2%</p>
          <span className="metric-change positive">+0.8%</span>
        </div>
      </div>

      <div className="charts-grid">
        <div className="chart-card">
          <h3>User Growth</h3>
          <ResponsiveContainer width="100%" height={300}>
            <LineChart data={data}>
              <CartesianGrid strokeDasharray="3 3" />
              <XAxis dataKey="name" />
              <YAxis />
              <Tooltip />
              <Legend />
              <Line type="monotone" dataKey="users" stroke="#3b82f6" />
            </LineChart>
          </ResponsiveContainer>
        </div>

        <div className="chart-card">
          <h3>Revenue Overview</h3>
          <ResponsiveContainer width="100%" height={300}>
            <BarChart data={data}>
              <CartesianGrid strokeDasharray="3 3" />
              <XAxis dataKey="name" />
              <YAxis />
              <Tooltip />
              <Legend />
              <Bar dataKey="revenue" fill="#10b981" />
            </BarChart>
          </ResponsiveContainer>
        </div>

        <div className="chart-card">
          <h3>Device Distribution</h3>
          <ResponsiveContainer width="100%" height={300}>
            <PieChart>
              <Pie
                data={pieData}
                cx="50%"
                cy="50%"
                labelLine={false}
                label={({ name, percent }) => `${name} ${(percent * 100).toFixed(0)}%`}
                outerRadius={80}
                fill="#8884d8"
                dataKey="value"
              >
                {pieData.map((entry, index) => (
                  <Cell key={`cell-${index}`} fill={entry.color} />
                ))}
              </Pie>
              <Tooltip />
            </PieChart>
          </ResponsiveContainer>
        </div>
      </div>
    </div>
  );
}

export default App;