import React from 'react';
import { Post } from '../App';
import './BlogList.css';

interface BlogListProps {
  posts: Post[];
  onEdit: (post: Post) => void;
  onView: (post: Post) => void;
}

export default function BlogList({ posts, onEdit, onView }: BlogListProps) {
  const formatDate = (dateString: string) => {
    return new Date(dateString).toLocaleDateString('en-US', {
      year: 'numeric',
      month: 'long',
      day: 'numeric'
    });
  };

  return (
    <div className="blog-list">
      <h2>Blog Posts</h2>
      <div className="posts-grid">
        {posts.map(post => (
          <div key={post.id} className="post-card">
            <div className="post-header">
              <h3 onClick={() => onView(post)}>{post.title}</h3>
              <span className={`status ${post.published ? 'published' : 'draft'}`}>
                {post.published ? 'Published' : 'Draft'}
              </span>
            </div>
            <p className="excerpt">{post.excerpt}</p>
            <div className="post-meta">
              <span>By {post.author}</span>
              <span>{formatDate(post.date)}</span>
            </div>
            <div className="post-tags">
              {post.tags.map(tag => (
                <span key={tag} className="tag">{tag}</span>
              ))}
            </div>
            <div className="post-actions">
              <button onClick={() => onView(post)} className="btn btn-secondary">View</button>
              <button onClick={() => onEdit(post)} className="btn btn-primary">Edit</button>
            </div>
          </div>
        ))}
      </div>
    </div>
  );
}