import React from 'react';
import ReactMarkdown from 'react-markdown';
import { Post } from '../App';
import './BlogPost.css';

interface BlogPostProps {
  post: Post;
  onEdit: () => void;
  onBack: () => void;
}

export default function BlogPost({ post, onEdit, onBack }: BlogPostProps) {
  const formatDate = (dateString: string) => {
    return new Date(dateString).toLocaleDateString('en-US', {
      year: 'numeric',
      month: 'long',
      day: 'numeric'
    });
  };

  return (
    <article className="blog-post">
      <div className="post-actions-bar">
        <button onClick={onBack} className="btn btn-secondary">← Back to Posts</button>
        <button onClick={onEdit} className="btn btn-primary">Edit Post</button>
      </div>

      <header className="post-header">
        <h1>{post.title}</h1>
        <div className="post-meta">
          <span>By {post.author}</span>
          <span>{formatDate(post.date)}</span>
        </div>
        <div className="post-tags">
          {post.tags.map(tag => (
            <span key={tag} className="tag">#{tag}</span>
          ))}
        </div>
      </header>

      <div className="post-content">
        <ReactMarkdown>{post.content}</ReactMarkdown>
      </div>
    </article>
  );
}