import React, { useState } from 'react';
import './MediaLibrary.css';

interface MediaItem {
  id: string;
  name: string;
  url: string;
  type: 'image' | 'video' | 'document';
  size: string;
  uploadedAt: string;
}

export default function MediaLibrary() {
  const [mediaItems] = useState<MediaItem[]>([
    {
      id: '1',
      name: 'hero-image.jpg',
      url: 'https://via.placeholder.com/300x200',
      type: 'image',
      size: '245 KB',
      uploadedAt: new Date().toISOString()
    },
    {
      id: '2',
      name: 'product-photo.png',
      url: 'https://via.placeholder.com/300x200',
      type: 'image',
      size: '189 KB',
      uploadedAt: new Date().toISOString()
    }
  ]);

  return (
    <div className="media-library">
      <div className="media-header">
        <h2>Media Library</h2>
        <button className="btn btn-primary">
          Upload Files
        </button>
      </div>

      <div className="media-grid">
        {mediaItems.map(item => (
          <div key={item.id} className="media-item">
            <div className="media-preview">
              {item.type === 'image' && (
                <img src={item.url} alt={item.name} />
              )}
              {item.type !== 'image' && (
                <div className="file-icon">📄</div>
              )}
            </div>
            <div className="media-info">
              <div className="media-name">{item.name}</div>
              <div className="media-meta">{item.size}</div>
            </div>
          </div>
        ))}
      </div>
    </div>
  );
}