import React from 'react';
import { Site } from '../App';
import './Sidebar.css';

interface SidebarProps {
  view: string;
  onViewChange: (view: 'content' | 'editor' | 'media' | 'settings') => void;
  sites: Site[];
  selectedSite: string;
  onSiteChange: (siteId: string) => void;
  onNewContent: () => void;
}

export default function Sidebar({ view, onViewChange, sites, selectedSite, onSiteChange, onNewContent }: SidebarProps) {
  const menuItems = [
    { id: 'content', label: 'Content', icon: '📄' },
    { id: 'media', label: 'Media Library', icon: '🖼️' },
    { id: 'settings', label: 'Settings', icon: '⚙️' }
  ];

  return (
    <aside className="sidebar">
      <div className="sidebar-header">
        <h1>CMS Pro</h1>
      </div>
      
      <div className="site-selector">
        <label>Active Site</label>
        <select value={selectedSite} onChange={(e) => onSiteChange(e.target.value)}>
          {sites.map(site => (
            <option key={site.id} value={site.id}>{site.name}</option>
          ))}
        </select>
      </div>
      
      <button className="new-content-btn" onClick={onNewContent}>
        + New Content
      </button>
      
      <nav className="sidebar-nav">
        {menuItems.map(item => (
          <button
            key={item.id}
            className={`nav-item ${view === item.id ? 'active' : ''}`}
            onClick={() => onViewChange(item.id as any)}
          >
            <span className="icon">{item.icon}</span>
            <span>{item.label}</span>
          </button>
        ))}
      </nav>
    </aside>
  );
}