import React, { useState } from 'react';
import './App.css';

interface Content {
  id: string;
  title: string;
  type: 'video' | 'article' | 'podcast';
  views: number;
  likes: number;
  publishedAt: string;
  thumbnail: string;
}

function App() {
  const [contents] = useState<Content[]>([
    {
      id: '1',
      title: 'How I Built My First Million Dollar Business',
      type: 'video',
      views: 125432,
      likes: 5643,
      publishedAt: '2 days ago',
      thumbnail: '🎥'
    },
    {
      id: '2',
      title: '10 Productivity Tips That Changed My Life',
      type: 'article',
      views: 45231,
      likes: 2341,
      publishedAt: '1 week ago',
      thumbnail: '📄'
    },
    {
      id: '3',
      title: 'Interview with Tech Leaders - Episode 23',
      type: 'podcast',
      views: 23456,
      likes: 1234,
      publishedAt: '3 days ago',
      thumbnail: '🎙️'
    }
  ]);

  return (
    <div className="app">
      <header className="header">
        <h1>Creator Studio</h1>
        <nav>
          <button className="nav-btn active">Dashboard</button>
          <button className="nav-btn">Content</button>
          <button className="nav-btn">Analytics</button>
          <button className="nav-btn">Community</button>
          <button className="nav-btn">Monetization</button>
        </nav>
        <button className="create-btn">+ Create</button>
      </header>

      <div className="container">
        <div className="stats-overview">
          <div className="stat-card">
            <h3>Total Subscribers</h3>
            <p className="stat-value">245K</p>
            <span className="stat-change positive">+12.5%</span>
          </div>
          <div className="stat-card">
            <h3>Monthly Views</h3>
            <p className="stat-value">1.2M</p>
            <span className="stat-change positive">+23.8%</span>
          </div>
          <div className="stat-card">
            <h3>Revenue</h3>
            <p className="stat-value">$12,543</p>
            <span className="stat-change positive">+18.2%</span>
          </div>
          <div className="stat-card">
            <h3>Engagement Rate</h3>
            <p className="stat-value">8.7%</p>
            <span className="stat-change negative">-0.5%</span>
          </div>
        </div>

        <div className="content-section">
          <div className="section-header">
            <h2>Recent Content</h2>
            <button className="view-all-btn">View All</button>
          </div>
          
          <div className="content-grid">
            {contents.map(content => (
              <div key={content.id} className="content-card">
                <div className="content-thumbnail">
                  <span className="thumbnail-icon">{content.thumbnail}</span>
                  <span className="content-type">{content.type}</span>
                </div>
                <div className="content-info">
                  <h3>{content.title}</h3>
                  <div className="content-stats">
                    <span>👁️ {content.views.toLocaleString()} views</span>
                    <span>❤️ {content.likes.toLocaleString()} likes</span>
                  </div>
                  <span className="published-date">{content.publishedAt}</span>
                </div>
              </div>
            ))}
          </div>
        </div>

        <div className="audience-section">
          <h2>Audience Insights</h2>
          <div className="insights-grid">
            <div className="insight-card">
              <h4>Top Demographics</h4>
              <ul>
                <li>18-24 years: 35%</li>
                <li>25-34 years: 42%</li>
                <li>35-44 years: 18%</li>
                <li>45+ years: 5%</li>
              </ul>
            </div>
            <div className="insight-card">
              <h4>Top Locations</h4>
              <ul>
                <li>United States: 45%</li>
                <li>United Kingdom: 12%</li>
                <li>Canada: 8%</li>
                <li>Australia: 6%</li>
              </ul>
            </div>
            <div className="insight-card">
              <h4>Traffic Sources</h4>
              <ul>
                <li>YouTube: 52%</li>
                <li>Direct: 23%</li>
                <li>Social Media: 18%</li>
                <li>Search: 7%</li>
              </ul>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
}

export default App;