import React from 'react'
import { cn } from '../utils'

interface NavigationProps {
  appName: string
  pages: Array<{ name: string; href: string; current?: boolean }>
  primaryColor?: string
  onPageChange?: (page: string) => void
}

export function Navigation({ appName, pages, primaryColor = '#2563eb', onPageChange }: NavigationProps) {
  return (
    <nav className="fixed top-0 left-0 right-0 bg-white border-b border-gray-200 z-50">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="flex justify-between h-16">
          <div className="flex items-center">
            <div className="flex-shrink-0">
              <h1 className="text-xl font-bold text-gray-900">{appName}</h1>
            </div>
          </div>
          
          <div className="hidden sm:ml-6 sm:flex sm:space-x-8">
            {pages.map((page) => (
              <button
                key={page.name}
                onClick={() => onPageChange?.(page.name)}
                className={cn(
                  'inline-flex items-center px-1 pt-1 border-b-2 text-sm font-medium transition-colors',
                  page.current
                    ? 'border-blue-500 text-gray-900'
                    : 'border-transparent text-gray-500 hover:border-gray-300 hover:text-gray-700'
                )}
                style={page.current ? { borderColor: primaryColor } : {}}
              >
                {page.name}
              </button>
            ))}
          </div>
        </div>
      </div>
    </nav>
  )
}