import React from 'react'
import { Card, CardContent } from '../ui/Card'
import { Button } from '../ui/Button'

interface Product {
  id: string
  name: string
  price: number
  description: string
  icon: string
}

interface ProductsPageProps {
  config: any
  onAddToCart: (product: { id: string; name: string; price: number; icon: string }) => void
}

export function ProductsPage({ config, onAddToCart }: ProductsPageProps) {
  const products: Product[] = [
    { id: '1', name: 'Premium Headphones', price: 299, description: 'High-quality wireless headphones', icon: '🎧' },
    { id: '2', name: 'Smart Watch', price: 399, description: 'Feature-rich smartwatch', icon: '⌚' },
    { id: '3', name: 'Laptop Stand', price: 89, description: 'Ergonomic laptop stand', icon: '💻' },
    { id: '4', name: 'Wireless Mouse', price: 59, description: 'Precision wireless mouse', icon: '🖱️' },
    { id: '5', name: 'Keyboard', price: 149, description: 'Mechanical gaming keyboard', icon: '⌨️' },
    { id: '6', name: 'Monitor', price: 449, description: '4K ultra-wide monitor', icon: '🖥️' },
  ]

  return (
    <div className="max-w-7xl mx-auto px-4 py-8">
      <h1 className="text-3xl font-bold text-gray-900 mb-8">Products</h1>
      
      <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
        {products.map((product) => (
          <Card key={product.id} className="hover:shadow-lg transition-shadow">
            <CardContent className="p-6">
              <div className="text-center mb-4">
                <div className="text-6xl mb-4">{product.icon}</div>
                <h3 className="text-xl font-semibold text-gray-900">{product.name}</h3>
                <p className="text-gray-600 mt-2">{product.description}</p>
              </div>
              
              <div className="flex items-center justify-between mt-4">
                <span className="text-2xl font-bold" style={{ color: config.primaryColor }}>
                  $${product.price}
                </span>
                <Button
                  onClick={() => onAddToCart({
                    id: product.id,
                    name: product.name,
                    price: product.price,
                    icon: product.icon
                  })}
                  style={{ backgroundColor: config.primaryColor }}
                >
                  Add to Cart
                </Button>
              </div>
            </CardContent>
          </Card>
        ))}
      </div>
    </div>
  )
}