import React, { useState } from 'react';
import './App.css';

interface Course {
  id: string;
  title: string;
  instructor: string;
  duration: string;
  level: string;
  enrolled: number;
  progress: number;
  thumbnail: string;
}

function App() {
  const [courses] = useState<Course[]>([
    {
      id: '1',
      title: 'Introduction to React',
      instructor: 'Jane Smith',
      duration: '6 weeks',
      level: 'Beginner',
      enrolled: 1234,
      progress: 65,
      thumbnail: '⚛️'
    },
    {
      id: '2',
      title: 'Advanced TypeScript',
      instructor: 'John Doe',
      duration: '4 weeks',
      level: 'Advanced',
      enrolled: 567,
      progress: 30,
      thumbnail: '📘'
    },
    {
      id: '3',
      title: 'Web Design Fundamentals',
      instructor: 'Sarah Johnson',
      duration: '8 weeks',
      level: 'Beginner',
      enrolled: 2345,
      progress: 0,
      thumbnail: '🎨'
    }
  ]);

  const [activeTab, setActiveTab] = useState('my-courses');

  return (
    <div className="app">
      <header className="header">
        <h1>EduPlatform</h1>
        <nav>
          <button className="nav-btn">Dashboard</button>
          <button className="nav-btn active">Courses</button>
          <button className="nav-btn">Progress</button>
          <button className="nav-btn">Community</button>
        </nav>
        <div className="user-menu">
          <span className="user-avatar">👤</span>
        </div>
      </header>

      <div className="container">
        <div className="welcome-section">
          <h2>Welcome back, Student!</h2>
          <p>Continue your learning journey</p>
        </div>

        <div className="tabs">
          <button
            className={`tab ${activeTab === 'my-courses' ? 'active' : ''}`}
            onClick={() => setActiveTab('my-courses')}
          >
            My Courses
          </button>
          <button
            className={`tab ${activeTab === 'browse' ? 'active' : ''}`}
            onClick={() => setActiveTab('browse')}
          >
            Browse Catalog
          </button>
          <button
            className={`tab ${activeTab === 'completed' ? 'active' : ''}`}
            onClick={() => setActiveTab('completed')}
          >
            Completed
          </button>
        </div>

        <div className="courses-grid">
          {courses.map(course => (
            <div key={course.id} className="course-card">
              <div className="course-thumbnail">
                <span className="thumbnail-icon">{course.thumbnail}</span>
              </div>
              <div className="course-info">
                <h3>{course.title}</h3>
                <p className="instructor">by {course.instructor}</p>
                <div className="course-meta">
                  <span className="level">{course.level}</span>
                  <span className="duration">{course.duration}</span>
                </div>
                {course.progress > 0 ? (
                  <div className="progress-section">
                    <div className="progress-bar">
                      <div 
                        className="progress-fill" 
                        style={{ width: `${course.progress}%` }}
                      />
                    </div>
                    <span className="progress-text">{course.progress}% Complete</span>
                  </div>
                ) : (
                  <div className="enrollment">
                    <span className="enrolled">{course.enrolled.toLocaleString()} enrolled</span>
                    <button className="enroll-btn">Enroll Now</button>
                  </div>
                )}
              </div>
            </div>
          ))}
        </div>

        <div className="stats-section">
          <div className="stat-card">
            <h4>Learning Streak</h4>
            <p className="stat-value">7 days</p>
            <span className="stat-label">Keep it up!</span>
          </div>
          <div className="stat-card">
            <h4>Courses Completed</h4>
            <p className="stat-value">12</p>
            <span className="stat-label">This year</span>
          </div>
          <div className="stat-card">
            <h4>Certificates Earned</h4>
            <p className="stat-value">8</p>
            <span className="stat-label">View all</span>
          </div>
          <div className="stat-card">
            <h4>Study Time</h4>
            <p className="stat-value">156h</p>
            <span className="stat-label">This month</span>
          </div>
        </div>
      </div>
    </div>
  );
}

export default App;