import React from 'react'
import { Button } from './ui/Button'
import { Card, CardContent } from './ui/Card'

export default function App() {
  const config = {
    appName: 'Landing Page Pro',
    primaryColor: '#2563eb'
  }

  return (
    <div className="min-h-screen">
      {/* Hero Section */}
      <section className="relative overflow-hidden bg-gradient-to-br from-blue-50 to-indigo-100 py-20">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center">
            <h1 className="text-4xl md:text-5xl font-bold text-gray-900 mb-6">
              Welcome to {config.appName}
            </h1>
            <p className="text-xl text-gray-600 mb-8 max-w-2xl mx-auto">
              Build something amazing with our modern, responsive template that's optimized for conversions.
            </p>
            <div className="flex gap-4 justify-center">
              <Button size="lg" style={{ backgroundColor: config.primaryColor }}>
                Get Started
              </Button>
              <Button size="lg" variant="outline">
                Learn More
              </Button>
            </div>
          </div>
        </div>
      </section>

      {/* Features Section */}
      <section className="py-20 bg-white">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center mb-12">
            <h2 className="text-3xl font-bold text-gray-900 mb-4">
              Amazing Features
            </h2>
            <p className="text-xl text-gray-600">
              Everything you need to succeed
            </p>
          </div>
          
          <div className="grid md:grid-cols-3 gap-8">
            {[
              { icon: '⚡', title: 'Lightning Fast', desc: 'Built for speed and performance' },
              { icon: '🛡️', title: 'Secure by Default', desc: 'Enterprise-grade security built in' },
              { icon: '📱', title: 'Mobile First', desc: 'Responsive design that works everywhere' },
              { icon: '🎨', title: 'Beautiful Design', desc: 'Modern UI that users love' },
              { icon: '🔧', title: 'Easy to Customize', desc: 'Adapt it to your needs quickly' },
              { icon: '📈', title: 'Analytics Ready', desc: 'Track your success from day one' }
            ].map((feature, index) => (
              <Card key={index} className="hover:shadow-lg transition-shadow">
                <CardContent className="p-6">
                  <div className="text-4xl mb-4">{feature.icon}</div>
                  <h3 className="text-xl font-semibold mb-2">{feature.title}</h3>
                  <p className="text-gray-600">{feature.desc}</p>
                </CardContent>
              </Card>
            ))}
          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="py-20 bg-gray-50">
        <div className="max-w-4xl mx-auto text-center px-4">
          <h2 className="text-3xl font-bold text-gray-900 mb-4">
            Ready to Get Started?
          </h2>
          <p className="text-xl text-gray-600 mb-8">
            Join thousands of satisfied customers using our product
          </p>
          <Button size="lg" style={{ backgroundColor: config.primaryColor }}>
            Start Your Free Trial
          </Button>
        </div>
      </section>
    </div>
  )
}