import React, { useState } from 'react';
import './App.css';

interface Post {
  id: string;
  author: string;
  avatar: string;
  content: string;
  likes: number;
  comments: number;
  timestamp: string;
  liked: boolean;
}

function App() {
  const [posts, setPosts] = useState<Post[]>([
    {
      id: '1',
      author: 'Jane Smith',
      avatar: '👩',
      content: 'Just launched my new project! Excited to share it with the community 🚀',
      likes: 42,
      comments: 8,
      timestamp: '2 hours ago',
      liked: false
    },
    {
      id: '2',
      author: 'John Doe',
      avatar: '👨',
      content: 'Amazing weather today! Perfect for coding outdoors ☀️💻',
      likes: 28,
      comments: 3,
      timestamp: '5 hours ago',
      liked: true
    }
  ]);

  const [newPost, setNewPost] = useState('');

  const handlePost = () => {
    if (newPost.trim()) {
      const post: Post = {
        id: Date.now().toString(),
        author: 'You',
        avatar: '🧑',
        content: newPost,
        likes: 0,
        comments: 0,
        timestamp: 'Just now',
        liked: false
      };
      setPosts([post, ...posts]);
      setNewPost('');
    }
  };

  const toggleLike = (postId: string) => {
    setPosts(posts.map(post => 
      post.id === postId 
        ? { ...post, liked: !post.liked, likes: post.liked ? post.likes - 1 : post.likes + 1 }
        : post
    ));
  };

  return (
    <div className="app">
      <header className="header">
        <h1>Social Platform</h1>
        <nav>
          <button className="nav-btn active">Feed</button>
          <button className="nav-btn">Messages</button>
          <button className="nav-btn">Profile</button>
        </nav>
      </header>

      <div className="container">
        <aside className="sidebar">
          <div className="profile-card">
            <div className="avatar">🧑</div>
            <h3>Your Name</h3>
            <p>@yourhandle</p>
            <div className="stats">
              <div>
                <strong>120</strong>
                <span>Following</span>
              </div>
              <div>
                <strong>450</strong>
                <span>Followers</span>
              </div>
            </div>
          </div>

          <div className="trending">
            <h3>Trending Topics</h3>
            <ul>
              <li>#WebDevelopment</li>
              <li>#React</li>
              <li>#TypeScript</li>
              <li>#OpenSource</li>
            </ul>
          </div>
        </aside>

        <main className="feed">
          <div className="post-box">
            <textarea
              value={newPost}
              onChange={(e) => setNewPost(e.target.value)}
              placeholder="What's on your mind?"
              rows={3}
            />
            <button onClick={handlePost} className="post-btn">Post</button>
          </div>

          <div className="posts">
            {posts.map(post => (
              <article key={post.id} className="post">
                <div className="post-header">
                  <div className="author">
                    <span className="avatar">{post.avatar}</span>
                    <div>
                      <h4>{post.author}</h4>
                      <span className="timestamp">{post.timestamp}</span>
                    </div>
                  </div>
                </div>
                <p className="post-content">{post.content}</p>
                <div className="post-actions">
                  <button 
                    className={`action-btn ${post.liked ? 'liked' : ''}`}
                    onClick={() => toggleLike(post.id)}
                  >
                    ❤️ {post.likes}
                  </button>
                  <button className="action-btn">💬 {post.comments}</button>
                  <button className="action-btn">🔄 Share</button>
                </div>
              </article>
            ))}
          </div>
        </main>

        <aside className="right-sidebar">
          <div className="suggestions">
            <h3>Who to Follow</h3>
            <div className="user-list">
              <div className="user">
                <span className="avatar">👩‍💻</span>
                <div>
                  <h4>Sarah Dev</h4>
                  <span>@sarahdev</span>
                </div>
                <button className="follow-btn">Follow</button>
              </div>
              <div className="user">
                <span className="avatar">👨‍💼</span>
                <div>
                  <h4>Mike Tech</h4>
                  <span>@miketech</span>
                </div>
                <button className="follow-btn">Follow</button>
              </div>
            </div>
          </div>
        </aside>
      </div>
    </div>
  );
}

export default App;